<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Create;

use JMS\Serializer\SerializerBuilder;
use Lifestyle\DataCollector\DataCollector;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Create\Mapper;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Translation;
use PHPUnit\Framework\TestCase;

/**
 * Class MapperTest
 * @package Tests\Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Create
 */
class MapperTest extends TestCase
{
    public function testMapping()
    {
        $collector = $this->prepareDataCollector();

        $mapper = new Mapper();
        $requestModel = $mapper->mapRequestModel($collector);
        $requestModel->setTranslations([new Translation()]);

        // Assert base data
        $this->assertSame('size', $requestModel->getCode());
        $this->assertEquals(1, count($requestModel->getValues()));
        $value = $requestModel->getValues()[0];
        $this->assertEquals('size_S', $value->getCode());
        $translations = $value->getTranslations();
        $this->assertEquals(2, count($translations));
        $this->assertEquals(['de_DE', 'en_US'], array_keys($translations->toArray()));
        $this->assertEquals('S', $translations->get('de_DE')->getValue());
        $this->assertEquals('de_DE', $translations->get('de_DE')->getLocale());
        $this->assertEquals('S', $translations->get('en_US')->getValue());
        $this->assertEquals('en_US', $translations->get('en_US')->getLocale());
        $this->assertEquals(null, $translations->get('en_US')->getName());
    }

    public function testSerialization()
    {
        $collector = $this->prepareDataCollector();

        $mapper = new Mapper();
        $requestModel = $mapper->mapRequestModel($collector);

        $serializer = SerializerBuilder::create()->build();
        $json = $serializer->serialize($requestModel, 'json');

        $this->assertSame(
            '{"code":"size","values":[{"code":"size_S","translations":{"de_DE":{"value":"S"},"en_US":{"value":"S"}}}],"translations":{"de_DE":{"name":"size"},"en_US":{"name":"size"}}}',
            $json
        );
    }

    /**
     * @return DataCollectorInterface
     */
    private function prepareDataCollector()
    {
        // Add base attributes
        $collector = new DataCollector();

        $collector->addItem('optionCode', 'size');
        $collector->addItem('optionValue', 'S');
        $collector->addItem('optionValueCode', 'size_S');
        $collector->addItem('locales', ['de_DE', 'en_US']);

        return $collector;
    }
}
