<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Response;

use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Response\ProductOption;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Value;
use PHPUnit\Framework\TestCase;

/**
 * Class ProductOptionTest
 * @package Tests\Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Response
 */
class ProductOptionTest extends TestCase
{
    public function testGetterSetter()
    {
        $productOption = new ProductOption();
        $productOption->setId(1);
        $productOption->setCode('size');
        $productOption->setPosition(0);
        $value = new Value();
        $productOption->setValues([$value]);
        $productOption->setTranslations([]);
        $productOption->setLinks(0);

        $this->assertSame(1, $productOption->getId());
        $this->assertSame('size', $productOption->getCode());
        $this->assertSame(0, $productOption->getPosition());
        $this->assertSame([$value], $productOption->getValues());
        $this->assertSame([], $productOption->getTranslations());
        $this->assertSame(0, $productOption->getLinks());
    }
}
