# SyliusRestClientBundle
This Bundle provides a set of REST Services for client applications to connect the Sylius REST API for:
- **Products**
- **Variants**
- **Taxons**
- **ProductOptions**

Note: Unfortunately, Channel REST API is not support yet. Have a look at https://support.life-style.de/browse/MYWR-228

## Installation

**1 . Make sure you've added the repository in your composer.json file:**
 
 ```json
     {
         "repositories": [
             {
                 "type": "vcs",
                 "url": "ssh://git@stash.life-style.de:7999/sb/sylius-rest-client.git"
             }
         ]
     }
 ```

**2. Require the bundle with Composer:**
```bash
$ composer require lifestyle/sylius-rest-client-bundle dev-develop
```

**3. Register the bundle:**
```php
// app/AppKernel.php
 
public function registerBundles(): array
{
    $bundles = [
        new \Lifestyle\Sylius\RestApiClientBundle\LifestyleSyliusRestApiClientBundle(),
    ];
 
    // ...
}
```

**4. Now you can use the following REST Services provided by Symfony DI Component (service ids):**
- lifestyle_sylius_rest_api_client.export.product.version1.handler
- lifestyle_sylius_rest_api_client.export.product_variant.version1.handler
- lifestyle_sylius_rest_api_client.export.taxon.version1.handler

### Configuration

Add the following parameters to your parameters.yml:

```yaml
lifestyle_sylius_rest_api_client.api_base_uri: "http://sylius.localhost"
lifestyle_sylius_rest_api_client.api_user_name: "api@example.com"
lifestyle_sylius_rest_api_client.api_password: "sylius-api"
lifestyle_sylius_rest_api_client.api_token_url: "/api/oauth/v2/token"
lifestyle_sylius_rest_api_client.api_client_id: "demo_client"
lifestyle_sylius_rest_api_client.api_client_secret: "secret_demo_client"
```

#### Versioning

Configure the version to be used for Sylius REST API in your config.yml. Default version is '1'.
Based on this information, the corresponding services_version_{VERSION}.yml file will be loaded.
Therefore you need to add a services yml file for each new version. 

```yaml
lifestyle_sylius_rest_api_client:
    version: '1'
```
