<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Create;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Request\ProductOption;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Translation as OptionTranslation;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Value;

/**
 * Class Mapper
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Create
 */
class Mapper
{
    /**
     * @param DataCollectorInterface $collector
     * @return ProductOption
     */
    public function mapRequestModel(DataCollectorInterface $collector)
    {
        $optionCode = $collector->getItemValue('optionCode');
        $optionValue = $collector->getItemValue('optionValue');
        $locales = $collector->getItemValue('locales');

        $productOptionRequest = new ProductOption();
        $productOptionRequest->setCode($optionCode);

        foreach ($locales as $locale) {
            $translation = new OptionTranslation();
            $translation->setName($optionCode);
            $translation->setLocale($locale);
            $productOptionRequest->addTranslation($translation);
        }

        $values = [];

        if (null !== $optionValue) {
            $optionValueCode = $collector->getItemValue('optionValueCode');
            $value = new Value();
            $value->setCode($optionValueCode);

            foreach ($locales as $locale) {
                $translation = new OptionTranslation();
                $translation->setLocale($locale);
                $translation->setValue($optionValue);
                $value->addTranslation($translation);
            }
            $values[] = $value;
        }
        $productOptionRequest->setValues($values);
        return $productOptionRequest;
    }
}
