<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1;

use Lifestyle\DataCollector\DataCollector;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Exception\RestRequestFailedException;
use Lifestyle\Sylius\RestApiClientBundle\Services\HandlerInterface;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1
 */
class Handler implements HandlerInterface
{
    const HANDLER_ID = 'Option';

    /**
     * @var Factory
     */
    private $serviceFactory;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param Factory $serviceFactory
     * @param LoggerInterface $logger
     */
    public function __construct(Factory $serviceFactory, LoggerInterface $logger)
    {
        $this->serviceFactory = $serviceFactory;
        $this->logger = $logger;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        return $collector->getItemValue('className') === self::HANDLER_ID;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param string $type
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function createOrUpdateOptions(DataCollectorInterface $collector, $type = 'options')
    {
        $locales = $collector->getCollectedLocales();
        // create options if they don't exist
        foreach ($collector->getItemValue($type) as $optionCode => $optionValue) {
            $collector = new DataCollector();
            $collector->addItem('optionCode', $optionCode);
            $collector->addItem('optionValue', $optionValue);
            $collector->addItem('locales', $locales);
            $this->createOrUpdate($collector);
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function createOrUpdate(DataCollectorInterface $collector)
    {
        $this->logger->debug('ProductOption Create or Update ...');

        $optionCode = $collector->getItemValue('optionCode');
        $optionValue = $collector->getItemValue('optionValue');
        $optionValueCode = $optionCode . '_' . $optionValue;
        $collector->addItem('optionValueCode', $optionValueCode);

        $responseModel = $this->serviceFactory->get()->getByCode($optionCode);
        if (!$responseModel) {
            $this->logger->debug('ProductOption does not exist yet -> Create ...');
            $this->serviceFactory->create()->create($collector);
        } elseif ($collector->hasItem('optionValue')) {
            // check if value is present and then if exists
            // @TODO create a method in the responseModel called hasOptionValue instead of doing this here
            $valueExists = false;
            foreach ($responseModel->getValues() as $value) {
                if ($value->getCode() === $optionValueCode) {
                    $valueExists = true;
                    break;
                }
            }
            if (!$valueExists) {
                $this->logger->debug('ProductOptionValue does not exist yet -> Create ...');
                $collector->addItem('responseModel', $responseModel);
                $this->serviceFactory->update()->update($collector);
            }
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function delete(DataCollectorInterface $collector)
    {
        $this->logger->debug('ProductOption Delete ...');

        $optionCode = $collector->getItemValue('code');

        if ($this->serviceFactory->get()->exists($optionCode)) {
            $this->logger->debug('Product option exists -> Delete ...');
            $this->serviceFactory->delete()->deleteByCode($optionCode);
        }
    }
}
