<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Tests\DependencyInjection;

use Lifestyle\Sylius\RestApiClientBundle\DependencyInjection\Configuration;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Update\Model\Request\Product as ProductUpdate;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Create\Model\Request\Product as ProductCreate;
use Matthias\SymfonyConfigTest\PhpUnit\ConfigurationTestCaseTrait;
use PHPUnit\Framework\TestCase;

/**
 * Class ConfigurationTest
 * @package Lifestyle\Sylius\RestApiClientBundle\Tests\DependencyInjection
 */
class ConfigurationTest extends TestCase
{
    use ConfigurationTestCaseTrait;

    protected function getConfiguration()
    {
        return new Configuration();
    }

    public function testDefaultValueIsSet()
    {
        $config = [
            'version' => 1,
            'services' => [
                'product_variant' => [
                    'create' => [
                        'model' => ProductCreate::class
                    ],
                    'update' => [
                        'model' => ProductUpdate::class
                    ],
                ],
            ],
        ];

        $this->assertProcessedConfigurationEquals([], $config);
    }

    public function testOverwriteDefaultVersion()
    {
        $customConfig = [
            'version' => 2,
            'services' => [
                'product_variant' => [
                    'create' => [
                        'model' => 'Find\The\Difference\Create'
                    ],
                    'update' => [
                        'model' => 'Find\The\Difference\Update'
                    ],
                ],
            ],
        ];

        $expectedConfig = $customConfig;

        $this->assertProcessedConfigurationEquals([$customConfig], $expectedConfig);
    }
}
