<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Get\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ProductVariantData
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Get\Model\Response
 */
class ProductVariantData
{
    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $page;

    /**
     * @Serializer\Type("int")
     * @var string
     */
    private $limit;

    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $pages;

    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $total;

    /**
     * @return int
     */
    public function getPage(): int
    {
        return $this->page;
    }

    /**
     * @param int $page
     * @return ProductVariantData
     */
    public function setPage(int $page): ProductVariantData
    {
        $this->page = $page;
        return $this;
    }

    /**
     * @return string
     */
    public function getLimit(): string
    {
        return $this->limit;
    }

    /**
     * @param string $limit
     * @return ProductVariantData
     */
    public function setLimit(string $limit): ProductVariantData
    {
        $this->limit = $limit;
        return $this;
    }

    /**
     * @return int
     */
    public function getPages(): int
    {
        return $this->pages;
    }

    /**
     * @param int $pages
     * @return ProductVariantData
     */
    public function setPages(int $pages): ProductVariantData
    {
        $this->pages = $pages;
        return $this;
    }

    /**
     * @return int
     */
    public function getTotal(): int
    {
        return $this->total;
    }

    /**
     * @param int $total
     * @return ProductVariantData
     */
    public function setTotal(int $total): ProductVariantData
    {
        $this->total = $total;
        return $this;
    }
}
