<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1;

use Lifestyle\DataCollector\DataCollector;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Exception\RestRequestFailedException;
use Lifestyle\Sylius\RestApiClientBundle\Services\HandlerInterface;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1
 */
class Handler implements HandlerInterface
{
    const HANDLER_ID = 'Option';

    /**
     * @var Factory
     */
    private $serviceFactory;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param Factory $serviceFactory
     * @param LoggerInterface $logger
     */
    public function __construct(Factory $serviceFactory, LoggerInterface $logger)
    {
        $this->serviceFactory = $serviceFactory;
        $this->logger = $logger;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        if ($collector->getItemValue('className') !== 'Product') {
            return false;
        }

        if ($collector->hasItem('options')) {
            return true;
        }

        foreach ($collector->getCollectedLocales() as $locale) {
            if ($collector->hasItem('options', $locale)) {
                return true;
            }
        }

        return false;
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function createOrUpdate(DataCollectorInterface $collector)
    {
        $this->logger->debug('ProductOption Create or Update ...');

        $options = $collector->hasItem('options') ? $collector->getItemValue('options') : [];
        foreach ((is_array($options) ? $options : [$options]) as $optionCode) {
            if (!$collector->hasItem('options_' . $optionCode)) {
                continue;
            }

            $responseModel = $this->serviceFactory->get()->getByCode($optionCode);
            if ($responseModel) {
                $this->logger->debug('ProductOption exist  -> Update ...');
                $this->serviceFactory->update()->update($collector, $optionCode, $responseModel);
            } else {
                $this->logger->debug('ProductOption does not exist yet -> Create ...');
                $this->serviceFactory->create()->create($collector, $optionCode);
            }
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function delete(DataCollectorInterface $collector)
    {
        $this->logger->debug('ProductOption Delete ...');

        $optionCode = $collector->getItemValue('code');

        if ($this->serviceFactory->get()->exists($optionCode)) {
            $this->logger->debug('Product option exists -> Delete ...');
            $this->serviceFactory->delete()->deleteByCode($optionCode);
        }
    }
}
