<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\GetCollection\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ProductVariant
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\GetCollection\Model\Response
 */
class ProductVariant
{
    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $id;

    /**
     * @Serializer\Type("string")
     * @var string
     */
    private $code;

    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $position;

    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $version;

    /**
     * @Serializer\SerializedName("onHold")
     * @Serializer\Type("int")
     * @var int
     */
    private $onHold;

    /**
     * @Serializer\SerializedName("onHand")
     * @Serializer\Type("int")
     * @var int
     */
    private $onHand;

    /**
     * @Serializer\Type("bool")
     * @var bool
     */
    private $tracked;

    /**
     * @Serializer\Type("array<Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\GetCollection\Model\Response\ChannelPrice>")
     * @Serializer\SerializedName("channelPricings")
     * @var ChannelPrice[]
     */
    private $channelPricings;

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @return int
     */
    public function getPosition(): int
    {
        return $this->position;
    }

    /**
     * @return int
     */
    public function getVersion(): int
    {
        return $this->version;
    }

    /**
     * @return int
     */
    public function getOnHold(): int
    {
        return $this->onHold;
    }

    /**
     * @return int
     */
    public function getOnHand(): int
    {
        return $this->onHand;
    }

    /**
     * @return bool
     */
    public function isTracked(): bool
    {
        return $this->tracked;
    }

    /**
     * @return ChannelPrice[]
     */
    public function getChannelPricings(): array
    {
        return $this->channelPricings;
    }
}
