<?php

namespace Lifestyle\Sylius\RestApiClientBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;
use Symfony\Component\Yaml\Yaml;

/**
 * This is the class that loads and manages your bundle configuration.
 *
 * @link http://symfony.com/doc/current/cookbook/bundles/extension.html
 */
class LifestyleSyliusRestApiClientExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));

        // Load base services
        $loader->load('services_base.yml');

        // Load services for given version.
        $loader->load('services_version_' . $config['version'] .'.yml');

        $this->setRequestModelClasses($config, $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function setRequestModelClasses(array $config, ContainerBuilder $container)
    {
        $container->getDefinition('lifestyle_sylius_rest_api_client.export.product_variant.version1.create.mapper')
            ->addMethodCall('setModelClass', [$config['services']['product_variant']['create']['model']]);

        $container->getDefinition('lifestyle_sylius_rest_api_client.export.product_variant.version1.update.mapper')
            ->addMethodCall('setModelClass', [$config['services']['product_variant']['update']['model']]);
    }
}
