<?php

/**
 * Class Session
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Persistence;

use Symfony\Component\HttpFoundation\Session\SessionInterface;

/**
 * Class Session
 * @package Lifestyle\Sylius\RestApiClientBundle\Persistence
 */
class Session implements PersistenceInterface
{
    /**
     * @var SessionInterface
     */
    private $session;

    /**
     * Session constructor.
     * @param SessionInterface $session
     */
    public function __construct(SessionInterface $session)
    {
        $this->session = $session;
    }

    /**
     * @param string $key
     * @return mixed
     */
    public function load($key)
    {
        return $this->session->has($key) ? $this->session->get($key) : null;
    }

    /**
     * @param string $key
     * @param mixed $data
     */
    public function persist($key, $data)
    {
        $this->session->set($key, $data);
    }
}
