<?php

/**
 * Class Handler
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\Taxon\Version1;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Exception\RestRequestFailedException;
use Lifestyle\Sylius\RestApiClientBundle\Services\HandlerInterface;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\Taxon\Version1
 */
class Handler implements HandlerInterface
{
    const HANDLER_ID = 'Taxon';

    /**
     * @var Factory
     */
    private $serviceFactory;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param Factory $serviceFactory
     * @param LoggerInterface $logger
     */
    public function __construct(Factory $serviceFactory, LoggerInterface $logger)
    {
        $this->serviceFactory = $serviceFactory;
        $this->logger = $logger;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        return $collector->getItemValue('className') === self::HANDLER_ID;
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @throws RestRequestFailedException
     */
    public function createOrUpdate(DataCollectorInterface $collector)
    {
        $this->logger->debug('Taxon Create or Update ...');

        if ($this->serviceFactory->get()->exists($collector->getItemValue('id'))) {
            $this->logger->debug('Taxon already exists -> Update ...');
            $this->serviceFactory->update()->update($collector);
        } else {
            $this->logger->debug('Taxon does not exist yet -> Create ...');
            $this->serviceFactory->create()->create($collector);
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws \GuzzleHttp\Exception\GuzzleException
     * @throws RestRequestFailedException
     */
    public function delete(DataCollectorInterface $collector)
    {
        $this->logger->debug('Taxon Delete ...');

        if ($this->serviceFactory->get()->exists($collector->getItemValue('id'))) {
            $this->logger->debug('Taxon exists -> Delete ...');
            $this->serviceFactory->delete()->deleteByCode($collector->getItemValue('id'));
        }
    }
}
