<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Create\Model\Request;

/**
 * Class Association
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Create\Model\Request
 */
class Association
{
    /**
     * @var string
     */
    private $type;

    /**
     * @var string|null
     */
    private $value;

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @param string $type
     * @return Association
     */
    public function setType(string $type): Association
    {
        $this->type = $type;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getValue(): ?string
    {
        return $this->value;
    }

    /**
     * @param null|string $value
     * @return Association
     */
    public function setValue(?string $value): Association
    {
        $this->value = $value;
        return $this;
    }
}
