<?php

/**
 * Class Product
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Create\Model\Request;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Product
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Create\Model\Request
 */
class Product
{
    /**
     * @var string|null
     */
    private $code;

    /**
     * @var bool
     */
    private $enabled = true;

    /**
     * @Serializer\SerializedName("mainTaxon")
     * @var string|null
     */
    private $mainTaxon;

    /**
     * @Serializer\SerializedName("productTaxons")
     * @var string|null
     */
    private $productTaxon;

    /**
     * @var array
     */
    private $channels;

    /**
     * @var array
     */
    private $options;

    /**
     * @var Attribute[]
     */
    private $attributes;

    /**
     * @var ArrayCollection|Translation[]
     */
    private $translations;

    /**
     * @var ArrayCollection|Association[]
     */
    private $associations;

    public function __construct()
    {
        $this->translations = new ArrayCollection();
        $this->associations = new ArrayCollection();
    }

    /**
     * @return null|string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param null|string $code
     */
    public function setCode($code)
    {
        $this->code = $code;
    }

    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->enabled;
    }

    /**
     * @param bool $enabled
     */
    public function setEnabled($enabled)
    {
        $this->enabled = $enabled;
    }

    /**
     * @return null|string
     */
    public function getMainTaxon()
    {
        return $this->mainTaxon;
    }

    /**
     * @param null|string $mainTaxon
     */
    public function setMainTaxon($mainTaxon)
    {
        $this->mainTaxon = $mainTaxon;
    }

    /**
     * @return mixed
     */
    public function getProductTaxon()
    {
        return $this->productTaxon;
    }

    /**
     * @param string|null $productTaxon
     */
    public function setProductTaxon(?string $productTaxon)
    {
        $this->productTaxon = $productTaxon;
    }

    /**
     * @return array
     */
    public function getChannels()
    {
        return $this->channels;
    }

    /**
     * @param array $channels
     */
    public function setChannels($channels)
    {
        $this->channels = $channels;
    }

    /**
     * @return array
     */
    public function getOptions(): array
    {
        return $this->options;
    }

    /**
     * @param array $options
     * @return Product
     */
    public function setOptions(array $options): Product
    {
        $this->options = $options;
        return $this;
    }

    /**
     * @param Attribute $attribute
     */
    public function addAttribute(Attribute $attribute)
    {
        $this->attributes[] = $attribute;
    }

    /**
     * @return Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @param Translation $translation
     */
    public function addTranslation(Translation $translation)
    {
        $this->translations->set($translation->getLocale(), $translation);
    }

    /**
     * @return ArrayCollection|Translation[]
     */
    public function getTranslations()
    {
        return $this->translations;
    }

    /**
     * @return ArrayCollection|Association[]
     */
    public function getAssociations()
    {
        return $this->associations;
    }

    /**
     * @param Association $association
     * @return Product
     */
    public function addAssociation(Association $association)
    {
        $this->associations->set($association->getType(), $association->getValue());
        return $this;
    }
}
