<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Helper;

use Symfony\Component\HttpKernel\CacheClearer\CacheClearerInterface;
use Symfony\Component\Cache\Simple\FilesystemCache;

/**
 * Class OAuthTokenCacheClearer
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\RestApiClientBundle\Helper
 */
class OAuthTokenCacheClearer implements CacheClearerInterface
{
    /**
     * Clears any caches necessary.
     *
     * Symfony FilesystemCache cannot be cleared by removing the var/cache folder.
     * Data is stored outside the application in systems var-folder!
     *
     * @param string $cacheDir The cache directory
     */
    public function clear($cacheDir)
    {
        (new FilesystemCache(OAuthTokenCache::CACHE_NAMESPACE))->clear();
    }
}
