<?php

/**
 * Class MapperTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Tests\Services\ProductOption\Version1\Update;

use JMS\Serializer\SerializerBuilder;
use Lifestyle\DataCollector\DataCollector;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Response\ProductOption;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Value;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Update\Mapper;
use PHPUnit\Framework\TestCase;

/**
 * Class MapperTest
 * @package Lifestyle\Sylius\RestApiClientBundle\Tests\Services\ProductVariant\Version1\Update
 */
class MapperTest extends TestCase
{
    public function testMapping()
    {
        $collector = $this->prepareDataCollector();

        $mapper = new Mapper();
        $requestModel = $mapper->mapRequestModel($collector);

        // Assert base data
        $this->assertSame('size', $requestModel->getCode());
    }

    public function testSerialization()
    {
        $collector = $this->prepareDataCollector();

        $mapper = new Mapper();
        $requestModel = $mapper->mapRequestModel($collector);

        $serializer = SerializerBuilder::create()->build();
        $json = $serializer->serialize($requestModel, 'json');

        $this->assertSame(
            '{"code":"size","values":[{"code":"size","translations":{"de_DE":{"value":"S"},"en_US":{"value":"S"}}},{"code":"size_S","translations":{"de_DE":{"value":"S"},"en_US":{"value":"S"}}}],"translations":{"de_DE":{"name":"size"},"en_US":{"name":"size"}}}',
            $json
        );
    }

    /**
     * @return DataCollectorInterface
     */
    private function prepareDataCollector()
    {
        // Add base attributes
        $collector = new DataCollector();

        $responseModel = new ProductOption();
        $value = new Value();
        $value->setCode('size');
        $value->setTranslations(['de_DE' => ['value' => 'S', 'locale' => 'de_DE'], 'en_US' => ['value' => 'S', 'locale' => 'en_US']]);
        $responseModel->setValues([$value]);

        $collector->addItem('responseModel', $responseModel);
        $collector->addItem('optionCode', 'size');
        $collector->addItem('optionValue', 'S');
        $collector->addItem('optionValueCode', 'size_S');
        $collector->addItem('locales', ['de_DE', 'en_US']);
        return $collector;
    }
}
