<?php

/**
 * Interface HandlerInterface
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services;

use Lifestyle\DataCollector\DataCollectorInterface;

/**
 * Interface HandlerInterface
 * @package Lifestyle\Sylius\RestApiClientBundle\Services
 */
interface HandlerInterface
{
    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector);

    /**
     * @param DataCollectorInterface $collector
     */
    public function createOrUpdate(DataCollectorInterface $collector);

    /**
     * @param DataCollectorInterface $collector
     */
    public function delete(DataCollectorInterface $collector);
}
