<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\GetCollection\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Embedded
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\GetCollection\Model\Response
 */
class Embedded
{
    /**
     * @Serializer\Type("array<Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\GetCollection\Model\Response\ProductVariant>")
     * @Serializer\SerializedName("items")
     * @var ProductVariant[]
     */
    private $productVariants;

    /**
     * @return ProductVariant[]
     */
    public function getProductVariants(): array
    {
        return $this->productVariants;
    }
}
