<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Create\Model\Request;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Interface ProductVariantInterface
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Create\Model\Request
 */
interface ProductVariantInterface
{
    /**
     * @return null|string
     */
    public function getCode();

    /**
     * @param null|string $code
     * @return ProductVariantInterface
     */
    public function setCode($code);

    /**
     * @param bool|null $enabled
     */
    public function setEnabled(?bool $enabled): void;

    /**
     * @param Translation $translation
     */
    public function addTranslation(Translation $translation);

    /**
     * @return ArrayCollection|Translation[]
     */
    public function getTranslations();

    /**
     * @param ChannelPrice $pricing
     */
    public function addChannelPricing(ChannelPrice $pricing);

    /**
     * @return ArrayCollection|ChannelPrice[]
     */
    public function getChannelPricing();

    /**
     * @return int
     */
    public function getOnHand();

    /**
     * @param int $onHand
     * @return ProductVariantInterface
     */
    public function setOnHand($onHand);

    /**
     * @param string|null $taxCategory
     */
    public function setTaxCategory(?string $taxCategory): void;

    /**
     * @param string|null $shippingCategory
     */
    public function setShippingCategory(?string $shippingCategory): void;

    /**
     * @param bool|null $shippingRequired
     */
    public function setShippingRequired(?bool $shippingRequired): void;

    /**
     * @return bool
     */
    public function isTracked();

    /**
     * @param bool $tracked
     * @return ProductVariantInterface
     */
    public function setTracked($tracked);

    /**
     * @return int
     */
    public function getHeight();

    /**
     * @param int $height
     * @return ProductVariantInterface
     */
    public function setHeight($height);

    /**
     * @return int
     */
    public function getWidth();

    /**
     * @param int $width
     * @return ProductVariantInterface
     */
    public function setWidth($width);

    /**
     * @return int
     */
    public function getDepth();

    /**
     * @param int $depth
     * @return ProductVariantInterface
     */
    public function setDepth($depth);

    /**
     * @return int
     */
    public function getWeight();

    /**
     * @param int $weight
     * @return ProductVariantInterface
     */
    public function setWeight($weight);

    /**
     * @return int
     */
    public function getVersion();

    /**
     * @param int $version
     * @return ProductVariantInterface
     */
    public function setVersion($version);

    /**
     * @return ArrayCollection
     */
    public function getOptionValues(): ArrayCollection;

    /**
     * @param string|int $key
     * @param mixed $value
     * @return ProductVariantInterface
     */
    public function addOptionValue($key, $value): ProductVariantInterface;
}
