<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\ApiConfiguration;

/**
 * Class ProductVariantServiceConfiguration
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\RestApiClientBundle\ApiConfiguration
 */
class ProductVariantServiceConfiguration
{
    /**
     * @var bool
     */
    private $enableShippingCategory;

    /**
     * ProductVariantServiceConfiguration constructor.
     * @param bool $enableShippingCategory
     */
    public function __construct(bool $enableShippingCategory)
    {
        $this->enableShippingCategory = $enableShippingCategory;
    }

    /**
     * @return bool
     */
    public function isEnableShippingCategory(): bool
    {
        return $this->enableShippingCategory;
    }
}
