<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Create;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Request\SelectAttribute;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Request\TextAttribute;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Request\Factory;


/**
 * Class Mapper
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Create
 */
class Mapper
{
    /**
     * @var Factory
     */
    private $factory;

    /**
     * Mapper constructor.
     * @param Factory $factory
     */
    public function __construct(Factory $factory)
    {
        $this->factory = $factory;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param string $attributeCode
     * @return TextAttribute
     */
    public function mapTextAttribute(DataCollectorInterface $collector, string $attributeCode): TextAttribute
    {
        $locales = $collector->getItemValue('locales');

        $attribute = $this->factory->textAttribute();
        $attribute->setCode($attributeCode);

        foreach ($locales as $locale) {
            $attributes = [];
            if ($collector->hasItem('attributes_translated', $locale)) {
                $attributes = $collector->getItemValue('attributes_translated', $locale);
            }

            // Add the attribute labels here - attribute values will be set in product update handler
            $translation = $this->factory->translation();
            $translation->setName(isset($attributes[$attributeCode]) ? $attributes[$attributeCode] : $attributeCode);
            $translation->setLocale($locale);

            $attribute->addTranslation($translation);
        }

        return $attribute;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param string $attributeCode
     * @return SelectAttribute
     */
    public function mapSelectAttribute(DataCollectorInterface $collector, string $attributeCode): SelectAttribute
    {
        $locales = $collector->getItemValue('locales');

        $attribute = $this->factory->selectAttribute();
        $attribute->setCode($attributeCode);

        $choices = [];
        foreach ($locales as $locale) {
            $attributes = [];
            if ($collector->hasItem('attributes_translated', $locale)) {
                $attributes = $collector->getItemValue('attributes_translated', $locale);
            }

            $translation = $this->factory->translation();
            $translation->setName(isset($attributes[$attributeCode]) ? $attributes[$attributeCode] : $attributeCode);
            $translation->setLocale($locale);

            $attribute->addTranslation($translation);

            // @TODO Get choices from translated element 'attributes_translated_' . $attributeCode
            $choice = isset($choices[$attributeCode]) ? $choices[$attributeCode] : ($choices[$attributeCode] = $this->factory->choice());
            $choice->addTranslation($locale, $attributes[$attributeCode]);
        }

        $configuration = $this->factory->configuration();
        $configuration->setMultiple(false); // @TODO Should be configurable, don't forget to configure min/max values
        foreach ($choices as $choice) {
            $configuration->addChoice($choice);
        }

        $attribute->setConfiguration($configuration);

        return $attribute;
    }
}
