<?php

/**
 * Class HandlerTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Tests\Services\Product\Version1\Create;

use GuzzleHttp\Exception\ClientException;
use JMS\Serializer\SerializerInterface;
use Lifestyle\DataCollector\DataCollector;
use Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Create\Handler;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Handler as OptionHandler;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Handler as AttributesHandler;
use Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Create\Mapper;
use Lifestyle\Sylius\RestApiClientBundle\Exception\RestRequestFailedException;
use Psr\Http\Message\RequestInterface;
use Psr\Log\LoggerInterface;
use PHPUnit\Framework\TestCase;
use GuzzleHttp\Client;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Psr7\Response;

/**
 * Class HandlerTest
 * @package Lifestyle\Sylius\RestApiClientBundle\Tests\Services\Product\Version1\Create
 */
class HandlerTest extends TestCase
{

    protected $optionHandlerMock;
    protected $attributesHandlerMock;
    protected $serializerMock;
    protected $loggerMock;
    protected $mapperMock;

    public function setUp()
    {
        parent::setUp();
        $this->optionHandlerMock = $this->getMockBuilder(OptionHandler::class)->disableOriginalConstructor()->getMock();
        $this->attributesHandlerMock = $this->getMockBuilder(AttributesHandler::class)->disableOriginalConstructor()->getMock();
        $this->serializerMock = $this->getMockBuilder(SerializerInterface::class)->getMock();
        $this->loggerMock = $this->getMockBuilder(LoggerInterface::class)->getMock();
        $this->mapperMock = $this->getMockBuilder(Mapper::class)->getMock();
    }


    public function testCreateSuccess()
    {

        // Create a mock and queue the responses.
        $mock = new MockHandler([
            new Response(201, []),
        ]);

        $handler = HandlerStack::create($mock);
        $client = new Client(['handler' => $handler]);

        $collector = new DataCollector();
        $collector->addItem('id', '123456');

        $createHandler = new Handler($this->serializerMock, $this->loggerMock, $client, $this->mapperMock);
        $this->assertTrue($createHandler->create($collector));
    }

    public function testCreateRequestUnexpectedClientException()
    {
        $this->expectException(RestRequestFailedException::class);


        // Create a mock and queue the responses.
        $mock = new MockHandler([
            new ClientException("", $this->getMockBuilder(RequestInterface::class)->getMock(), new Response(999)),
        ]);

        $handler = HandlerStack::create($mock);
        $client = new Client(['handler' => $handler]);

        $collector = new DataCollector();
        $collector->addItem('id', '123456');

        $createHandler = new Handler($this->serializerMock, $this->loggerMock, $client, $this->mapperMock, $this->optionHandlerMock, $this->attributesHandlerMock);
        $createHandler->create($collector);
    }

    public function testCreateRequestUnexpectedException()
    {
        $this->expectException(RestRequestFailedException::class);

        $serializer = $this->getMockBuilder(SerializerInterface::class)->getMock();
        $logger = $this->getMockBuilder(LoggerInterface::class)->getMock();
        $mapper = $this->getMockBuilder(Mapper::class)->getMock();
        $optionHandler = $this->getMockBuilder(OptionHandler::class)->disableOriginalConstructor()->getMock();
        $attributesHandler = $this->getMockBuilder(AttributesHandler::class)->disableOriginalConstructor()->getMock();

        // Create a mock and queue the responses.
        $mock = new MockHandler([
            new \Exception("unexpected mocked exception"),
        ]);

        $handler = HandlerStack::create($mock);
        $client = new Client(['handler' => $handler]);

        $collector = new DataCollector();
        $collector->addItem('id', '123456');

        $createHandler = new Handler($this->serializerMock, $this->loggerMock, $client, $this->mapperMock, $this->optionHandlerMock, $this->attributesHandlerMock);
        $createHandler->create($collector);
    }
}
