<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Value
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels
 */
class Value
{
    /**
     * @Serializer\Type("string")
     * @var string
     */
    private $code;

    /**
     * @Serializer\SerializedName("translations")
     * @Serializer\Type("ArrayCollection")
     * @var ArrayCollection|Translation[]
     */
    private $translations;

    public function __construct()
    {
        $this->translations = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return Value
     */
    public function setCode(string $code): Value
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return ArrayCollection|Translation[]
     */
    public function getTranslations()
    {
        return $this->translations;
    }

    /**
     * @param Translation $translation
     */
    public function addTranslation(Translation $translation)
    {
        $this->translations->set($translation->getLocale(), $translation);
    }

    /**
     * @param array $translations
     */
    public function setTranslations(array $translations)
    {
        $this->translations = $translations;
    }
}
