<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2018 Lifestyle Webconsulting GmbH
 * @link http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Event\ProductVariant;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Create\Model\Request\ProductVariantInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Class PreSerializeCreateModelEvent
 * @package Lifestyle\Sylius\RestApiClientBundle\Event\ProductVariant
 */
class PreSerializeCreateModelEvent extends Event
{
    const NAME = 'sylius_rest_api.product_variant.create.pre_serialize_model';

    /**
     * @var ProductVariantInterface
     */
    private $productVariant;

    /**
     * @var DataCollectorInterface
     */
    private $collector;

    /**
     * @param ProductVariantInterface $productVariant
     * @param DataCollectorInterface $collector
     */
    public function __construct(ProductVariantInterface $productVariant, DataCollectorInterface $collector)
    {
        $this->productVariant = $productVariant;
        $this->collector = $collector;
    }

    /**
     * @return ProductVariantInterface
     */
    public function getProductVariant(): ProductVariantInterface
    {
        return $this->productVariant;
    }

    /**
     * @return DataCollectorInterface
     */
    public function getCollector(): DataCollectorInterface
    {
        return $this->collector;
    }
}
