<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Helper\Mapper;

use Lifestyle\Sylius\RestApiClientBundle\Exception\RestRequestFailedException;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Trait RequestModelValidatorTrait
 * @package Lifestyle\Sylius\RestApiClientBundle\Helper\Mapper
 */
trait RequestModelValidatorTrait
{
    /**
     * @param ValidatorInterface $validator
     * @param string $errorMessagePrefix
     * @param mixed $validateObject
     * @throws RestRequestFailedException
     */
    private function validateRequest(ValidatorInterface $validator, string $errorMessagePrefix,  $validateObject): void
    {
        $violations = $validator->validate($validateObject);
        if (0 < count($violations)) {
            $errorMessages = [];
            foreach ($violations as $violation) {
                $errorMessages[] = (string)$violation;
            }
            throw new RestRequestFailedException(
                $errorMessagePrefix . ' - ' . implode(', ', $errorMessages),
                400
            );
        }
    }
}
