<?php

/**
 * Class Config
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services;

use Lifestyle\Sylius\RestApiClientBundle\Exception\InvalidConfigurationException;

/**
 * Class ConfigValidator
 * @package Lifestyle\Sylius\RestApiClientBundle\Services
 */
class ConfigValidator
{
    /**
     * @var string
     */
    private $apiBaseUri;

    /**
     * @var string
     */
    private $apiUserName;

    /**
     * @var string
     */
    private $apiPassword;

    /**
     * @var string
     */
    private $apiTokenUrl;

    /**
     * @var string
     */
    private $apiClientId;

    /**
     * @var string
     */
    private $apiClientSecret;

    /**
     * @param string $apiBaseUri
     * @param string $apiUserName
     * @param string $apiPassword
     * @param string $apiTokenUrl
     * @param string $apiClientId
     * @param string $apiClientSecret
     * @throws InvalidConfigurationException
     */
    public function __construct($apiBaseUri, $apiUserName, $apiPassword, $apiTokenUrl, $apiClientId, $apiClientSecret)
    {
        $this->apiBaseUri = $apiBaseUri;
        $this->apiUserName = $apiUserName;
        $this->apiPassword = $apiPassword;
        $this->apiTokenUrl = $apiTokenUrl;
        $this->apiClientId = $apiClientId;
        $this->apiClientSecret = $apiClientSecret;

        $this->validate();
    }

    /**
     * @throws InvalidConfigurationException
     */
    public function validate()
    {
        if (!strlen($this->apiBaseUri) ||
            !strlen($this->apiUserName) ||
            !strlen($this->apiPassword) ||
            !strlen($this->apiTokenUrl) ||
            !strlen($this->apiClientId) ||
            !strlen($this->apiClientSecret)
        ) {
            throw new InvalidConfigurationException(
                'Invalid or missing plugin configuration for sylius export handler!'
            );
        }
    }

    /**
     * @return array
     */
    public function toArray()
    {
        $attributes = array_keys(get_class_vars(self::class));

        $result = [];
        foreach ($attributes as $attribute) {
            $result[$attribute] = $this->$attribute;
        }

        return $result;
    }
}
