<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Response;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Translation;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Value;

/**
 * Class ProductAttributes
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Get\Model\Response
 */
class ProductAttributes
{
    /**
     * @Serializer\Type("int")
     * @Serializer\SerializedName("id")
     * @var int
     */
    private $identifier;

    /**
     * @Serializer\Type("string")
     * @var string
     */
    private $code;

    /**
     * @Serializer\Type("string")
     * @var string
     */
    private $type;

    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $position;

    /**
     * @Serializer\SerializedName("values")
     * @Serializer\Type("array<Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Value>")
     * @var Value[]
     */
    private $values;

    /**
     * @Serializer\SerializedName("translations")
     * @Serializer\Type("ArrayCollection")
     * @var ArrayCollection|Translation[]
     */
    private $translations;

    /**
     * @Serializer\SerializedName("links")
     * @Serializer\Type("int")
     * @var int
     */
    private $links;

    /**
     * @return int
     */
    public function getIdentifier(): int
    {
        return $this->identifier;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return int
     */
    public function getPosition(): int
    {
        return $this->position;
    }

    /**
     * @return Value[]
     */
    public function getValues(): array
    {
        return $this->values;
    }

    /**
     * @return ArrayCollection|Translation[]
     */
    public function getTranslations()
    {
        return $this->translations;
    }

    /**
     * @return int
     */
    public function getLinks(): int
    {
        return $this->links;
    }
}
