<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1;

use Lifestyle\DataCollector\DataCollector;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Exception\RestRequestFailedException;
use Lifestyle\Sylius\RestApiClientBundle\Services\HandlerInterface;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1
 */
class Handler implements HandlerInterface
{
    /**
     * @var Factory
     */
    private $serviceFactory;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param Factory $serviceFactory
     * @param LoggerInterface $logger
     */
    public function __construct(Factory $serviceFactory, LoggerInterface $logger)
    {
        $this->serviceFactory = $serviceFactory;
        $this->logger = $logger;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        if ($collector->getItemValue('className') !== 'Product') {
            return false;
        }

        if ($collector->hasItem('attributes')) {
            return true;
        }

        foreach ($collector->getCollectedLocales() as $locale) {
            if ($collector->hasItem('attributes', $locale)) {
                return true;
            }
        }

        return false;
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function createOrUpdate(DataCollectorInterface $collector)
    {
        $this->logger->debug('ProductAttributes Create or Update ...');

        $attributes = $collector->hasItem('attributes') ? $collector->getItemValue('attributes') : [];
        foreach ((is_array($attributes) ? $attributes : [$attributes]) as $attributeCode) {
            $responseModel = $this->serviceFactory->get()->getByCode($attributeCode);
            if (!$responseModel) {
                $this->logger->debug('ProductAttributes does not exist yet -> Create ...');
                $this->serviceFactory->create()->create($collector, $attributeCode, 'text'); // TODO Attribute type should be configurable
            } else {
                $this->logger->debug('ProductAttributes exist  -> Update ...');
                $this->serviceFactory->update()->update($collector, $attributeCode, $responseModel->getType());
            }
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function delete(DataCollectorInterface $collector)
    {
        $this->logger->debug('ProductAttributes Delete ...');

        if ($this->serviceFactory->get()->exists($collector->getItemValue('attributeCode'))) {
            $this->logger->debug('Product attribute exists -> Delete ...');
            $this->serviceFactory->delete()->deleteByCode($collector->getItemValue('attributeCode'));
        }
    }
}
