<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Get\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ChannelPrice
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Get\Model\Response
 */
class ChannelPrice
{
    /**
     * @Serializer\Type("string")
     * @Serializer\SerializedName("channelCode")
     * @var string
     */
    private $channelCode;

    /**
     * @Serializer\Type("int")
     * @Serializer\SerializedName("price")
     * @var int
     */
    private $price;

    /**
     * @Serializer\Type("int")
     * @Serializer\SerializedName("originalPrice")
     * @var int
     */
    private $originalPrice;

    /**
     * @return string
     */
    public function getChannelCode()
    {
        return $this->channelCode;
    }

    /**
     * @return int
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @return int
     */
    public function getOriginalPrice()
    {
        return $this->originalPrice;
    }
}
