<?php

/**
 * Class LifestylePimcoreSyliusExtensionTest
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Tests\Lifestyle\Pimcore\SwooxBundle\DependencyInjection;

use Lifestyle\Sylius\RestApiClientBundle\DependencyInjection\LifestyleSyliusRestApiClientExtension;
use Matthias\SymfonyDependencyInjectionTest\PhpUnit\AbstractExtensionTestCase;

/**
 * Class LifestylePimcoreSyliusExtensionTest
 * @package Tests\Lifestyle\Pimcore\SwooxBundle\DependencyInjection
 */
class LifestylePimcoreSyliusExtensionTest extends AbstractExtensionTestCase
{
    protected function getContainerExtensions()
    {
        return array(
            new LifestyleSyliusRestApiClientExtension()
        );
    }

    public function testServicesBaseYamlFileWillBeLoaded()
    {
        $this->load();

        // Look for a service within services_base.yml, to check, if services_base.yml has been loaded.
        $this->assertContainerBuilderHasService('lifestyle_sylius_rest_api_client.export.config');
    }

    public function testServicesVersion1YamlFileWillBeLoaded()
    {
        $this->load();

        // Look for a service within services_version_1.yml, to check, if services_version_1.yml has been loaded.
        $this->assertContainerBuilderHasService(
            'lifestyle_sylius_rest_api_client.export.product.version1.factory'
        );
    }
}
