<?php

/**
 * Class Translation
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Update\Model\Request;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Translation
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\Product\Version1\Update\Model\Request
 */
class Attribute
{
    /**
     * @Serializer\SerializedName("attribute")
     * @var string|null
     */
    private $attribute;

    /**
     * @Serializer\SerializedName("localeCode")
     * @var string|null
     */
    private $localeCode;

    /**
     * @Serializer\SerializedName("value")
     * @var string|null
     */
    private $value;

    /**
     * @return string|null
     */
    public function getAttribute()
    {
        return $this->attribute;
    }

    /**
     * @param string|null $attribute
     */
    public function setAttribute($attribute)
    {
        $this->attribute = $attribute;
    }

    /**
     * @return string|null
     */
    public function getLocaleCode()
    {
        return $this->localeCode;
    }

    /**
     * @param string|null $localeCode
     */
    public function setLocaleCode($localeCode)
    {
        $this->localeCode = $localeCode;
    }

    /**
     * @return string|null
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param string|null $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }
}
