<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Create;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Helper\Mapper\ProductOptionMapperTrait;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Request\ProductOption;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Translation;

/**
 * Class Mapper
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Create
 */
class Mapper
{
    use ProductOptionMapperTrait;

    /**
     * @param DataCollectorInterface $collector
     * @param string $optionCode
     * @return ProductOption
     */
    public function mapRequestModel(DataCollectorInterface $collector, string $optionCode)
    {
        $locales = $collector->getItemValue('locales');

        $productOptionRequest = new ProductOption();
        $productOptionRequest->setCode($optionCode);

        foreach ($locales as $locale) {
            $translatedOptions = $collector->getItemValue('options_translated', $locale);
            $translation = new Translation();
            $translation->setName(isset($translatedOptions[$optionCode]) ? $translatedOptions[$optionCode] : $optionCode);
            $translation->setLocale($locale);
            $productOptionRequest->addTranslation($translation);
        }

        $productOptionRequest->setValues(array_values($this->mapOptionValues($collector, $optionCode)));

        return $productOptionRequest;
    }
}
