<?php

namespace Lifestyle\Sylius\RestApiClientBundle\DependencyInjection;

use Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Create\Model\Request\Product as ProductCreate;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Update\Model\Request\Product as ProductUpdate;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('lifestyle_sylius_rest_api_client');

        $rootNode
            ->children()
                ->scalarNode('version')
                    ->defaultValue('1')
                ->end()
                ->arrayNode('services')
                    ->addDefaultsIfNotSet()
                    ->children()
                        ->arrayNode('product')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->booleanNode('enable_extra_fields')
                                    ->defaultFalse()
                                    ->info('Enable if your project supports the 4 extra fields in product.')
                                ->end()
                                ->arrayNode('create')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(ProductCreate::class)->cannotBeEmpty()->end()
                                    ->end()
                                ->end()
                                ->arrayNode('update')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(ProductUpdate::class)->cannotBeEmpty()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                    ->children()
                        ->arrayNode('product_variant')
                            ->addDefaultsIfNotSet()
                            ->children()
                                ->booleanNode('enable_shipping_category_update')
                                    ->defaultTrue()
                                    ->info('If shipping category management for product-variants should be handled by REST API, turn it on. If you want to assign shipping categories using the Sylius admin GUI, turn it off.')
                                ->end()
                                ->booleanNode('enable_sku')
                                    ->defaultTrue()
                                    ->info('Enable if product-variant supports sku-field.')
                                ->end()
                                ->arrayNode('create')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(ProductCreate::class)->cannotBeEmpty()->end()
                                    ->end()
                                ->end()
                                ->arrayNode('update')
                                    ->addDefaultsIfNotSet()
                                    ->children()
                                        ->scalarNode('model')->defaultValue(ProductUpdate::class)->cannotBeEmpty()->end()
                                    ->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end();

        return $treeBuilder;
    }
}
