<?php

/**
 * Class ProductOption
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Request;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Translation;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Value;

/**
 * Class ProductOption
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Request
 */
class ProductOption
{
    /**
     * @Serializer\Type("string")
     * @var string
     */
    private $code;

    /**
     * @Serializer\SerializedName("values")
     *
     * @Serializer\Type("array<Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Value>")
     * @var Value[]
     */
    private $values;

    /**
     * @Serializer\SerializedName("translations")
     * @var ArrayCollection|Translation[]
     */
    private $translations;

    public function __construct()
    {
        $this->translations = new ArrayCollection();
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return ProductOption
     */
    public function setCode(string $code): ProductOption
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return Value[]
     */
    public function getValues(): array
    {
        return $this->values;
    }

    /**
     * @param Value $value
     */
    public function addValue(Value $value): void
    {
        $this->values[] = $value;
    }

    /**
     * @param Value[] $values
     * @return ProductOption
     */
    public function setValues(array $values): ProductOption
    {
        foreach ($values as $value) {
            $this->addValue($value);
        }
        return $this;
    }

    /**
     * @param Translation $translation
     */
    public function addTranslation(Translation $translation)
    {
        $this->translations->set($translation->getLocale(), $translation);
    }

    /**
     * @param Translation[] $translations
     * @return ProductOption
     */
    public function setTranslations($translations): ProductOption
    {
        $this->translations = $translations;
        return $this;
    }
}
