<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Update;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Helper\Mapper\ProductOptionMapperTrait;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Request\ProductOption;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Response\ProductOption as ProductOptionResponse;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Translation;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Value;

/**
 * Class Mapper
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Update
 */
class Mapper
{
    use ProductOptionMapperTrait;

    /**
     * @param DataCollectorInterface $collector
     * @param string $optionCode
     * @param ProductOptionResponse $responseModel
     * @return ProductOption
     */
    public function mapRequestModel(
        DataCollectorInterface $collector,
        string $optionCode,
        ProductOptionResponse $responseModel
    ) {
        $locales = $collector->getItemValue('locales');

        $productOptionRequest = new ProductOption();
        $productOptionRequest->setCode($optionCode);

        foreach ($locales as $locale) {
            $translatedOptions = $collector->getItemValue('options_translated', $locale);
            $translation = new Translation();
            $translation->setName(isset($translatedOptions[$optionCode]) ? $translatedOptions[$optionCode] : $optionCode);
            $translation->setLocale($locale);
            $productOptionRequest->addTranslation($translation);
        }

        $values = $this->extractOldValues($responseModel);
        foreach ($this->mapOptionValues($collector, $optionCode) as $code => $value) {
            $values[$code] = $value;
        }

        $productOptionRequest->setValues(array_values($values));

        return $productOptionRequest;
    }

    /**
     * @param ProductOptionResponse $responseModel
     * @return Value[]
     */
    private function extractOldValues(ProductOptionResponse $responseModel)
    {
        $values = [];
        // prepare old values
        foreach ($responseModel->getValues() as $oldValue) {
            $value = new Value();
            $value->setCode($oldValue->getCode());

            foreach ($oldValue->getTranslations() as $oldTranslation) {
                $translation = new Translation();
                $translation->setValue($oldTranslation['value']);
                $translation->setLocale($oldTranslation['locale']);
                $value->addTranslation($translation);
            }
            $values[$value->getCode()] = $value;
        }
        return $values;
    }
}
