<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Model\Request;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class BulkPrice
 *
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Update\Model\Request
 */
class BulkPrice
{

    /**
     * @var string
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("channel")
     */
    private $channel;

    /**
     * @var int
     *
     * @Serializer\Type("int")
     * @Serializer\SerializedName("priceList")
     */
    private $list;

    /**
     * @var float
     *
     * @Serializer\Type("string")
     * @Serializer\SerializedName("price")
     */
    private $price;

    /**
     * @var int
     *
     * @Serializer\Type("int")
     * @Serializer\SerializedName("qty")
     */
    private $quantity;

    /**
     * @return string
     */
    public function getChannel(): string
    {
        return $this->channel;
    }

    /**
     * @param string $channel
     *
     * @return BulkPrice
     */
    public function setChannel(string $channel): BulkPrice
    {
        $this->channel = $channel;

        return $this;
    }

    /**
     * @return int
     */
    public function getList()
    {
        return $this->list;
    }

    /**
     * @param int $list
     *
     * @return BulkPrice
     */
    public function setList($list): BulkPrice
    {
        $this->list = $list;

        return $this;
    }

    /**
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param float $price
     *
     * @return BulkPrice
     */
    public function setPrice($price): BulkPrice
    {
        $this->price = $price;

        return $this;
    }

    /**
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }

    /**
     * @param int $quantity
     *
     * @return BulkPrice
     */
    public function setQuantity($quantity): BulkPrice
    {
        $this->quantity = $quantity;

        return $this;
    }
}
