<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\RestApiClientBundle\Services\TierPrice\Version1\Model\Request;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class TierPriceList
 *
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\TierPrice\Version1\Model\Request
 */
class TierPriceList
{

    /**
     * @var int
     *
     * @Serializer\SerializedName("id")
     * @Serializer\Type("int")
     */
    private $code;

    /**
     * @var string
     *
     * @Serializer\Type("string")
     */
    private $name;

    /**
     * @var int
     *
     * @Serializer\Type("int")
     */
    private $enabled;

    /**
     * @return int
     */
    public function getCode(): int
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return TierPriceList
     */
    public function setCode(int $code): TierPriceList
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return TierPriceList
     */
    public function setName(string $name): TierPriceList
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return int
     */
    public function getEnabled(): int
    {
        return $this->enabled;
    }

    /**
     * @param int $enabled
     * @return TierPriceList
     */
    public function setEnabled(int $enabled): TierPriceList
    {
        $this->enabled = $enabled;

        return $this;
    }
}
