<?php

/**
 * Class Translation
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Translation
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels
 */
class Translation
{
    /**
     * @var string|null
     * @Serializer\Type("string")
     */
    private $name;

    /**
     * @var string|null
     * @Serializer\Type("string")
     */
    private $value;

    /**
     * @Serializer\Exclude
     * @var string|null
     */
    private $locale;

    /**
     * @return null|string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param null|string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return null|string
     */
    public function getValue()
    {
        return $this->value;
    }

    /**
     * @param null|string $value
     */
    public function setValue($value)
    {
        $this->value = $value;
    }

    /**
     * @return null|string
     */
    public function getLocale()
    {
        return $this->locale;
    }

    /**
     * @param null|string $locale
     */
    public function setLocale($locale)
    {
        $this->locale = $locale;
    }
}
