<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\GetCollection\Model\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class Response
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\GetCollection\Model\Response
 */
class Response
{
    /**
     * @Serializer\Type("int")
     * @Serializer\SerializedName("page")
     * @var int
     */
    private $page;

    /**
     * @Serializer\Type("int")
     * @Serializer\SerializedName("limit")
     * @var int
     */
    private $limit;

    /**
     * @Serializer\Type("int")
     * @Serializer\SerializedName("pages")
     * @var int
     */
    private $pages;

    /**
     * @Serializer\Type("int")
     * @Serializer\SerializedName("total")
     * @var int
     */
    private $total;

    /**
     * @Serializer\Type("Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\GetCollection\Model\Response\Embedded")
     * @Serializer\SerializedName("_embedded")
     * @var Embedded
     */
    private $embedded;

    /**
     * @return int
     */
    public function getPage(): int
    {
        return $this->page;
    }

    /**
     * @return int
     */
    public function getLimit(): int
    {
        return $this->limit;
    }

    /**
     * @return int
     */
    public function getPages(): int
    {
        return $this->pages;
    }

    /**
     * @return int
     */
    public function getTotal(): int
    {
        return $this->total;
    }

    /**
     * @return Embedded
     */
    public function getEmbedded(): Embedded
    {
        return $this->embedded;
    }

    /**
     * @return ProductVariant[]
     */
    public function getProductVariants(): array
    {
        return $this->embedded->getProductVariants();
    }
}
