<?php

/**
 *  LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 *  and is protected by copyright law - it is NOT Freeware.
 *
 *  Any unauthorized use of this software without a valid license is a violation of the license agreement
 *  and will be prosecuted by civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Model\Request;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class StockInformation
 * @package App\Consumer\ProductVariant\Update\Model\Request
 */
class StockInformation
{
    /**
     * @var int
     * @Serializer\SerializedName("stockId")
     */
    protected int $code;

    /**
     * @var string
     * @Serializer\SerializedName("storageLocation")
     */
    protected string $storageLocation;

    /**
     * @var int
     * @Serializer\SerializedName("onHand")
     */
    protected int $onHand;

    /**
     * @return int
     */
    public function getCode(): int
    {
        return $this->code;
    }

    /**
     * @param int $code
     * @return StockInformation
     */
    public function setCode(int $code): StockInformation
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getStorageLocation(): string
    {
        return $this->storageLocation;
    }

    /**
     * @param string $storageLocation
     * @return StockInformation
     */
    public function setStorageLocation(string $storageLocation): StockInformation
    {
        $this->storageLocation = $storageLocation;

        return $this;
    }

    /**
     * @return int
     */
    public function getOnHand(): int
    {
        return $this->onHand;
    }

    /**
     * @param int $onHand
     * @return StockInformation
     */
    public function setOnHand(int $onHand): StockInformation
    {
        $this->onHand = $onHand;

        return $this;
    }
}
