<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\RestApiClientBundle\Services\TierPrice\Version1\Delete;

use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\GuzzleException;
use JMS\Serializer\SerializerInterface;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Exception\InvalidConfigurationException;
use Lifestyle\Sylius\RestApiClientBundle\Exception\RestRequestFailedException;
use Lifestyle\Sylius\RestApiClientBundle\Services\TierPrice\Version1\Update\Handler as UpdateHandler;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\TierPrice\Version1\Delete
 */
class Handler
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var ClientInterface
     */
    private $client;
    /**
     * @var UpdateHandler
     */
    private $updateHandler;

    /**
     * @param SerializerInterface $serializer
     * @param LoggerInterface     $logger
     * @param ClientInterface     $client
     * @param UpdateHandler       $updateHandler
     */
    public function __construct(
        SerializerInterface $serializer,
        LoggerInterface $logger,
        ClientInterface $client,
        UpdateHandler $updateHandler
    ) {
        $this->serializer = $serializer;
        $this->logger = $logger;
        $this->client = $client;
        $this->updateHandler = $updateHandler;
    }

    /**
     * @param DataCollectorInterface $collector
     *
     * @return bool
     *
     * @throws GuzzleException
     * @throws RestRequestFailedException
     * @throws InvalidConfigurationException
     */
    public function deleteByCode(DataCollectorInterface $collector)
    {
        $collector->addItem('enabled', 0);

        return $this->updateHandler->update($collector);
    }
}
