<?php

/**
 * Class LifestyleSyliusRestApiClient
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle;

use Doctrine\Common\Annotations\AnnotationRegistry;
use Lifestyle\Sylius\RestApiClientBundle\DependencyInjection\Compiler\AddFallbackLoggerPass;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;

/**
 * Class LifestyleSyliusRestApiClient
 *
 * @package Lifestyle\Sylius\RestApiClientBundle
 */
class LifestyleSyliusRestApiClientBundle extends Bundle
{
    /**
     * @param ContainerBuilder $container
     */
    public function build(ContainerBuilder $container)
    {
        parent::build($container);

        // Why do we have to do that? Shouldn't this be done automatically by symfony?
        AnnotationRegistry::registerLoader('class_exists');

        $container->addCompilerPass(new AddFallbackLoggerPass());
    }
}
