<?php

/**
 * Class Mapper
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Create;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Request\ProductAttributes;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Translation as AttributeTranslation;


/**
 * Class Mapper
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Create
 */
class Mapper
{
  /**
   * @param DataCollectorInterface $collector
   * @return ProductAttributes
   */
  public function mapRequestModel(DataCollectorInterface $collector)
  {
      $attributeCode = $collector->getItemValue('attributeCode');
      $locales = $collector->getItemValue('locales');

      $productAttributeRequest = new ProductAttributes();
      $productAttributeRequest->setCode($collector->getItemValue('attributeCode'));
      
      foreach ($locales as $locale) {
          $translation = new AttributeTranslation();
          $translation->setName($attributeCode);
          $translation->setLocale($locale);
          $productAttributeRequest->addTranslation($translation);
      }

      return $productAttributeRequest;
  }
}

