<?php

/**
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Response;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Translation;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Value;

/**
 * Class ProductAttributes
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Get\Model\Response
 */
class ProductAttributes
{
    /**
     * @Serializer\Type("int")
     * @Serializer\SerializedName("id")
     * @var int
     */
    private $identifier;

    /**
     * @Serializer\Type("string")
     * @var string
     */
    private $code;

    /**
     * @Serializer\Type("int")
     * @var int
     */
    private $position;

    /**
     * @Serializer\SerializedName("values")
     * @Serializer\Type("array<Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Value>")
     * @var Value[]
     */
    private $values;

    /**
     * @Serializer\SerializedName("translations")
     * @Serializer\Type("ArrayCollection")
     * @var ArrayCollection|Translation[]
     */
    private $translations;

    /**
     * @Serializer\SerializedName("links")
     * @Serializer\Type("int")
     * @var int
     */
    private $links;

    /**
     * ProductAttributes constructor.
     */
    public function __construct()
    {
        $this->values = [];
        $this->translations = new ArrayCollection();
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->identifier;
    }

    /**
     * @param int $identifier
     * @return ProductAttributes
     */
    public function setId(int $identifier): ProductAttributes
    {
        $this->identifier = $identifier;
        return $this;
    }

    /**
     * @return string
     */
    public function getCode(): string
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return ProductAttributes
     */
    public function setCode(string $code): ProductAttributes
    {
        $this->code = $code;
        return $this;
    }

    /**
     * @return int
     */
    public function getPosition(): int
    {
        return $this->position;
    }

    /**
     * @param int $position
     * @return ProductAttributes
     */
    public function setPosition(int $position): ProductAttributes
    {
        $this->position = $position;
        return $this;
    }

    /**
     * @return Value[]
     */
    public function getValues(): array
    {
        return $this->values;
    }

    /**
     * @param Value[] $values
     * @return ProductAttributes
     */
    public function setValues(array $values): ProductAttributes
    {
        $this->values = $values;
        return $this;
    }

    /**
     * @return Translation[]
     */
    public function getTranslations()
    {
        return $this->translations;
    }

    /**
     * @param Translation[] $translations
     * @return ProductAttributes
     */
    public function setTranslations(array $translations): ProductAttributes
    {
        $this->translations = $translations;
        return $this;
    }

    /**
     * @return int
     */
    public function getLinks(): int
    {
        return $this->links;
    }

    /**
     * @param int $links
     * @return ProductAttributes
     */
    public function setLinks(int $links): ProductAttributes
    {
        $this->links = $links;
        return $this;
    }
}
