<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1;

use Lifestyle\DataCollector\DataCollector;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Exception\RestRequestFailedException;
use Lifestyle\Sylius\RestApiClientBundle\Services\HandlerInterface;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1
 */
class Handler implements HandlerInterface
{
    const HANDLER_ID = 'Attributes';

    /**
     * @var Factory
     */
    private $serviceFactory;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @param Factory $serviceFactory
     * @param LoggerInterface $logger
     */
    public function __construct(Factory $serviceFactory, LoggerInterface $logger)
    {
        $this->serviceFactory = $serviceFactory;
        $this->logger = $logger;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        // won't be called directly but the interface need this one
        return true;
    }

    /**
     * @param DataCollectorInterface $collector
     * @param string $type
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
     public function createOrUpdateAttributes(DataCollectorInterface $collector, $type = 'attributes')
     {
         $locales = $collector->getCollectedLocales();
         // create attribute if they don't exist

         foreach ($collector->getItemValue($type) as $attributeCode => $attributeValue) {
             $collector = new DataCollector();
             $collector->addItem('attributeCode', $attributeCode);
             $collector->addItem('attributeValue', $attributeValue);
             $collector->addItem('locales', $locales);
             $this->createOrUpdate($collector);
         }
     }

    /**
     * @param DataCollectorInterface $collector
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function createOrUpdate(DataCollectorInterface $collector)
    {

        $this->logger->debug('ProductAttributes Create or Update ...');
        $this->logger->debug($collector->getItemValue('attributeCode'));


        $responseModel = $this->serviceFactory->get()->getByCode($collector->getItemValue('attributeCode'));
        if (!$responseModel) {
            $this->logger->debug('ProductAttributes does not exist yet -> Create ...');
            $this->serviceFactory->create()->create($collector);
        }
        else {
            $this->logger->debug('ProductAttributes exist  -> Update ...');
            $this->serviceFactory->update()->update($collector);
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws RestRequestFailedException
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function delete(DataCollectorInterface $collector)
    {
        $this->logger->debug('ProductAttributes Delete ...');

        if ($this->serviceFactory->get()->exists($collector->getItemValue('attributeCode'))) {
            $this->logger->debug('Product attribute exists -> Delete ...');
            $this->serviceFactory->delete()->deleteByCode($collector->getItemValue('attributeCode'));
        }
    }

}
