<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Update;

use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Request\ProductOption;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Response\ProductOption as ProductOptionResponse;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Translation;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\GeneralModels\Value;

/**
 * Class Mapper
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductOption\Version1\Update
 */
class Mapper
{
    /**
     * @param DataCollectorInterface $collector
     * @return ProductOption
     */
    public function mapRequestModel(DataCollectorInterface $collector)
    {
        /** @var ProductOptionResponse $responseModel */
        $responseModel = $collector->getItemValue('responseModel');
        $optionCode = $collector->getItemValue('optionCode');
        $optionValue = $collector->getItemValue('optionValue');
        $locales = $collector->getItemValue('locales');

        $productOptionRequest = new ProductOption();
        $productOptionRequest->setCode($optionCode);

        foreach ($locales as $locale) {
            $translation = new Translation();
            $translation->setName($optionCode);
            $translation->setLocale($locale);
            $productOptionRequest->addTranslation($translation);
        }

        $values = $this->extractOldValues($responseModel);

        if (null !== $optionValue) {
            $values[] = $this->prepareNewValue($collector);
        }

        $productOptionRequest->setValues($values);
        return $productOptionRequest;
    }

    /**
     * @param ProductOptionResponse $responseModel
     * @return array
     */
    private function extractOldValues(ProductOptionResponse $responseModel)
    {
        $values = [];
        // prepare old values
        foreach ($responseModel->getValues() as $oldValue) {
            $value = new Value();
            $value->setCode($oldValue->getCode());

            foreach ($oldValue->getTranslations() as $oldTranslation) {
                $translation = new Translation();
                $translation->setValue($oldTranslation['value']);
                $translation->setLocale($oldTranslation['locale']);
                $value->addTranslation($translation);
            }
            $values[] = $value;
        }
        return $values;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return Value
     */
    private function prepareNewValue(DataCollectorInterface $collector)
    {
        $optionValueCode = $collector->getItemValue('optionValueCode');
        $optionValue = $collector->getItemValue('optionValue');
        $locales = $collector->getItemValue('locales');
        $value = new Value();
        $value->setCode($optionValueCode);

        foreach ($locales as $locale) {
            $translation = new Translation();
            $translation->setLocale($locale);
            $translation->setValue($optionValue);
            $value->addTranslation($translation);
        }
        return $value;
    }
}
