<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Create\Model\Request;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ChannelPrice
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductVariant\Version1\Create\Model\Request
 */
class ChannelPrice
{
    /**
     * @Serializer\Type("string")
     *
     * @var float
     */
    private $price;

    /**
     * @Serializer\SerializedName("originalPrice")
     * @Serializer\Type("string")
     *
     * @var float
     */
    private $originalPrice;

    /**
     * @Serializer\Exclude
     * @var string
     */
    private $channel;

    /**
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * @param float $price
     * @return ChannelPrice
     */
    public function setPrice($price)
    {
        $this->price = $price;
        return $this;
    }

    /**
     * @return float
     */
    public function getOriginalPrice()
    {
        return $this->originalPrice;
    }

    /**
     * @param float $originalPrice
     * @return ChannelPrice
     */
    public function setOriginalPrice($originalPrice)
    {
        $this->originalPrice = $originalPrice;
        return $this;
    }

    /**
     * @return null|string
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * @param null|string $channel
     * @return ChannelPrice
     */
    public function setChannel($channel)
    {
        $this->channel = $channel;
        return $this;
    }
}
