<?php

/**
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1;

use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Create\Handler as CreateHandler;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Delete\Handler as DeleteHandler;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Get\Handler as GetHandler;
use Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\Update\Handler as UpdateHandler;

/**
 * Class Factory
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1
 */
class Factory
{
    /**
     * @var CreateHandler
     */
    private $createHandler;

    /**
     * @var DeleteHandler
     */
    private $deleteHandler;

    /**
     * @var GetHandler
     */
    private $getHandler;

    /**
     * @var UpdateHandler
     */
    private $updateHandler;

    /**
     * Factory constructor.
     * @param CreateHandler $create
     * @param DeleteHandler $delete
     * @param GetHandler $get
     * @param UpdateHandler $update
     */
    public function __construct(CreateHandler $create, DeleteHandler $delete, GetHandler $get, UpdateHandler $update)
    {
        $this->createHandler = $create;
        $this->deleteHandler = $delete;
        $this->getHandler = $get;
        $this->updateHandler = $update;
    }

    /**
     * @return CreateHandler
     */
    public function create()
    {
        return $this->createHandler;
    }

    /**
     * @return DeleteHandler
     */
    public function delete()
    {
        return $this->deleteHandler;
    }

    /**
     * @return GetHandler
     */
    public function get()
    {
        return $this->getHandler;
    }

    /**
     * @return UpdateHandler
     */
    public function update()
    {
        return $this->updateHandler;
    }
}
