<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Request;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class Choice
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\ProductAttributes\Version1\GeneralModels\Request
 */
class Choice
{
    /**
     * @var string[]|ArrayCollection
     */
    private $translations;

    /**
     * Choice constructor.
     */
    public function __construct()
    {
        $this->translations = new ArrayCollection();
    }

    /**
     * @param string $locale
     * @param string $value
     */
    public function addTranslation(string $locale, string $value)
    {
        $this->translations->set($locale, $value);
    }

    /**
     * @return ArrayCollection|string[]
     */
    public function getTranslations()
    {
        return $this->translations;
    }
}
