<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright 2020 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

declare(strict_types=1);

namespace Lifestyle\Sylius\RestApiClientBundle\Services\TierPrice\Version1;

use GuzzleHttp\Exception\GuzzleException;
use Lifestyle\DataCollector\DataCollectorInterface;
use Lifestyle\Sylius\RestApiClientBundle\Exception\InvalidConfigurationException;
use Lifestyle\Sylius\RestApiClientBundle\Exception\RestRequestFailedException;
use Lifestyle\Sylius\RestApiClientBundle\Services\HandlerInterface;
use Psr\Log\LoggerInterface;

/**
 * Class Handler
 * @package Lifestyle\Sylius\RestApiClientBundle\Services\TierPrice\Version1
 */
class Handler implements HandlerInterface
{
    private const HANDLER_ID = 'TierPriceList';

    /**
     * @var LoggerInterface
     */
    private $logger;
    /**
     * @var Get\Handler
     */
    private $getHandler;
    /**
     * @var Update\Handler
     */
    private $updateHandler;
    /**
     * @var Create\Handler
     */
    private $createHandler;
    /**
     * @var Delete\Handler
     */
    private $deleteHandler;

    /**
     * @param LoggerInterface $logger
     * @param Get\Handler     $getHandler
     * @param Update\Handler  $updateHandler
     * @param Create\Handler  $createHandler
     * @param Delete\Handler  $deleteHandler
     */
    public function __construct(
        LoggerInterface $logger,
        Get\Handler $getHandler,
        Update\Handler $updateHandler,
        Create\Handler $createHandler,
        Delete\Handler $deleteHandler
    ) {
        $this->logger = $logger;
        $this->getHandler = $getHandler;
        $this->updateHandler = $updateHandler;
        $this->createHandler = $createHandler;
        $this->deleteHandler = $deleteHandler;
    }

    /**
     * @param DataCollectorInterface $collector
     * @return bool
     */
    public function isResponsible(DataCollectorInterface $collector)
    {
        return $collector->getItemValue('className') === self::HANDLER_ID;
    }

    /**
     * createOrUpdate
     *
     * @param DataCollectorInterface $collector
     *
     * @throws GuzzleException
     * @throws RestRequestFailedException
     * @throws InvalidConfigurationException
     */
    public function createOrUpdate(DataCollectorInterface $collector)
    {

        $this->logger->debug('TierPriceList Create or Update ...');

        $responseModel = $this->getHandler->getByCode(
            $collector->getItemValue('id')
        );

        if ($responseModel) {
            $this->logger->debug('TierPriceList already exists -> Update ...');
            $this->updateHandler->update($collector);
        } else {
            $this->logger->debug('TierPriceList does not exist yet -> Create ...');
            $this->createHandler->create($collector);
        }
    }

    /**
     * @param DataCollectorInterface $collector
     * @throws RestRequestFailedException
     * @throws GuzzleException
     */
    public function delete(DataCollectorInterface $collector)
    {
        $this->logger->debug('TierPriceList Delete ...');

        if ($this->getHandler->exists($collector->getItemValue('id'))) {
            $this->logger->debug('TierPriceList exists -> Delete ...');

            $this->deleteHandler->deleteByCode($collector);
        }
    }
}
